/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.api.misc.ColorControl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RedstoneExtendedData
implements IExtendedConduitData<RedstoneExtendedData> {
    private boolean isActive = false;
    private final List<ColorControl> activeColors = new ArrayList<ColorControl>();
    private static final String KEY_ACTIVE = "Active";
    private static final String KEY_COLORED_ACTIVE = "ColoredActive";

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(KEY_ACTIVE, this.isActive);
        ListTag colors = new ListTag();
        for (ColorControl activeColor : this.activeColors) {
            colors.add((Object)IntTag.m_128679_((int)activeColor.ordinal()));
        }
        nbt.m_128365_(KEY_COLORED_ACTIVE, (Tag)colors);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.isActive = nbt.m_128471_(KEY_ACTIVE);
        this.activeColors.clear();
        if (nbt.m_128425_(KEY_COLORED_ACTIVE, 9)) {
            ListTag list = nbt.m_128437_(KEY_COLORED_ACTIVE, 3);
            for (Tag tag : list) {
                IntTag intTag;
                int intValue;
                if (!(tag instanceof IntTag) || (intValue = (intTag = (IntTag)tag).m_7047_()) < 0 || intValue >= ColorControl.values().length) continue;
                this.activeColors.add(ColorControl.values()[intValue]);
            }
        }
    }

    @Override
    public boolean syncDataToClient() {
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isActive(ColorControl color) {
        return this.activeColors.contains(color);
    }

    public void clearActive() {
        this.activeColors.clear();
        this.isActive = false;
    }

    public void setActiveColor(ColorControl color) {
        if (this.activeColors.contains(color)) {
            return;
        }
        this.isActive = true;
        this.activeColors.add(color);
    }

    @Override
    public RedstoneExtendedData deepCopy() {
        RedstoneExtendedData redstoneExtendedData = new RedstoneExtendedData();
        redstoneExtendedData.isActive = this.isActive;
        return redstoneExtendedData;
    }
}

