/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.IIOAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.init.ConduitBlocks;
import com.enderio.conduits.common.tag.ConduitTags;
import com.enderio.conduits.common.types.RedstoneExtendedData;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;

public class RedstoneConduitTicker
implements IIOAwareConduitTicker {
    private final List<ColorControl> activeColors = new ArrayList<ColorControl>();

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        BlockPos neighbor = conduitPos.m_121945_(direction);
        BlockState blockState = level.m_8055_(neighbor);
        return blockState.m_204336_(ConduitTags.Blocks.REDSTONE_CONNECTABLE) || blockState.canRedstoneConnectTo((BlockGetter)level, neighbor, direction);
    }

    @Override
    public void tickGraph(IConduitType<?> type, Graph<Mergeable.Dummy> graph, ServerLevel level, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        ArrayList<NodeIdentifier> nodeIdentifiers = new ArrayList<NodeIdentifier>();
        for (GraphObject object : graph.getObjects()) {
            if (!(object instanceof NodeIdentifier)) continue;
            NodeIdentifier node2 = (NodeIdentifier)object;
            nodeIdentifiers.add(node2);
        }
        this.activeColors.clear();
        this.tickGraph(type, nodeIdentifiers.stream().filter(node -> this.isLoaded((Level)level, node.getPos())).toList(), level, graph, isRedstoneActive);
        for (NodeIdentifier nodeIdentifier : nodeIdentifiers) {
            RedstoneExtendedData data = (RedstoneExtendedData)nodeIdentifier.getExtendedConduitData().cast();
            data.clearActive();
            for (ColorControl activeColor : this.activeColors) {
                data.setActiveColor(activeColor);
            }
        }
    }

    @Override
    public void tickColoredGraph(IConduitType<?> type, List<IIOAwareConduitTicker.Connection> inserts, List<IIOAwareConduitTicker.Connection> extracts, ColorControl color, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        for (IIOAwareConduitTicker.Connection extract : extracts) {
            if (!level.m_276987_(extract.move(), extract.dir())) continue;
            this.activeColors.add(color);
            break;
        }
        for (IIOAwareConduitTicker.Connection insert : inserts) {
            level.m_46586_(insert.move(), (Block)ConduitBlocks.CONDUIT.get(), insert.pos());
        }
    }

    @Override
    public int getTickRate() {
        return 2;
    }
}

