/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IConduitMenuData;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.IConduitTicker;
import com.enderio.api.misc.Vector2i;
import com.enderio.conduits.common.types.FluidClientData;
import com.enderio.conduits.common.types.FluidConduitTicker;
import com.enderio.conduits.common.types.FluidExtendedData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FluidConduitType
extends TieredConduit<FluidExtendedData> {
    public static final IConduitMenuData menuData = new IConduitMenuData.Simple(false, false, false, false, false, true);
    private final boolean isMultiFluid;
    private final int transferRate;

    public FluidConduitType(ResourceLocation texture, int tier, boolean isMultiFluid, ResourceLocation iconTexture, Vector2i iconTexturePos) {
        super(texture, new ResourceLocation("forge:fluid"), (isMultiFluid ? 100000 : 0) + tier, iconTexture, iconTexturePos);
        this.isMultiFluid = isMultiFluid;
        this.transferRate = tier;
        this.clientConduitData = new FluidClientData(iconTexture, iconTexturePos);
    }

    @Override
    public IConduitTicker getTicker() {
        return new FluidConduitTicker(!this.isMultiFluid, this.transferRate);
    }

    @Override
    public IConduitMenuData getMenuData() {
        return menuData;
    }

    @Override
    public FluidExtendedData createExtendedConduitData(Level level, BlockPos pos) {
        return new FluidExtendedData(this.isMultiFluid);
    }
}

