/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.types.FluidExtendedData;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.function.TriFunction;

public class FluidConduitTicker
extends CapabilityAwareConduitTicker<IFluidHandler> {
    private final boolean lockFluids;
    private final int fluidRate;

    public FluidConduitTicker(boolean lockFluids, int fluidRate) {
        this.lockFluids = lockFluids;
        this.fluidRate = fluidRate;
    }

    @Override
    public void tickGraph(IConduitType<?> type, List<NodeIdentifier<?>> loadedNodes, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        boolean shouldReset = false;
        for (NodeIdentifier<?> loadedNode : loadedNodes) {
            FluidExtendedData fluidExtendedData = loadedNode.getExtendedConduitData().castTo(FluidExtendedData.class);
            if (!fluidExtendedData.shouldReset) continue;
            shouldReset = true;
            fluidExtendedData.shouldReset = false;
        }
        if (shouldReset) {
            for (NodeIdentifier<?> loadedNode : loadedNodes) {
                loadedNode.getExtendedConduitData().castTo(FluidExtendedData.class).lockedFluid = null;
            }
        }
        super.tickGraph(type, loadedNodes, level, graph, isRedstoneActive);
    }

    @Override
    protected void tickCapabilityGraph(IConduitType<?> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IFluidHandler extractHandler = (IFluidHandler)extract.cap;
            FluidExtendedData fluidExtendedData = extract.data.castTo(FluidExtendedData.class);
            FluidStack extractedFluid = Optional.ofNullable(fluidExtendedData.lockedFluid).map(fluid -> extractHandler.drain(new FluidStack(fluid, this.fluidRate), IFluidHandler.FluidAction.SIMULATE)).orElseGet(() -> extractHandler.drain(this.fluidRate, IFluidHandler.FluidAction.SIMULATE));
            if (extractedFluid.isEmpty()) continue;
            int transferred = 0;
            for (int j = 0; j < inserts.size(); ++j) {
                FluidStack transferredFluid;
                FluidStack fluidStack = transferredFluid = fluidExtendedData.lockedFluid != null ? FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)inserts.get((int)j).cap), (IFluidHandler)extractHandler, (FluidStack)new FluidStack(fluidExtendedData.lockedFluid, this.fluidRate - transferred), (boolean)true) : FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)inserts.get((int)j).cap), (IFluidHandler)extractHandler, (int)(this.fluidRate - transferred), (boolean)true);
                if (transferredFluid.isEmpty()) continue;
                transferred += transferredFluid.getAmount();
                if (this.lockFluids) {
                    for (GraphObject graphObject : graph.getObjects()) {
                        if (!(graphObject instanceof NodeIdentifier)) continue;
                        NodeIdentifier node = (NodeIdentifier)graphObject;
                        Fluid fluid2 = transferredFluid.getFluid();
                        if (fluid2 instanceof FlowingFluid) {
                            FlowingFluid flowing = (FlowingFluid)fluid2;
                            fluid2 = flowing.m_5613_();
                        }
                        node.getExtendedConduitData().castTo(FluidExtendedData.class).lockedFluid = fluid2;
                    }
                }
                if (transferred > this.fluidRate) continue block0;
            }
        }
    }

    @Override
    protected Capability<IFluidHandler> getCapability() {
        return ForgeCapabilities.FLUID_HANDLER;
    }
}

