/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IExtendedConduitData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class EnergyExtendedData
implements IExtendedConduitData<EnergyExtendedData> {
    private final Map<Direction, EnergySidedData> energySidedData = new EnumMap<Direction, EnergySidedData>(Direction.class);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable EnergySidedData sidedData = this.energySidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toNbt());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energySidedData.clear();
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_(direction.name())) continue;
            this.energySidedData.put(direction, EnergySidedData.fromNbt(nbt.m_128469_(direction.name())));
        }
    }

    public EnergySidedData compute(Direction direction) {
        return this.energySidedData.computeIfAbsent(direction, dir -> new EnergySidedData());
    }

    public static class EnergySidedData {
        public int rotatingIndex = 0;
        private static final String KEY_ROTATING_INDEX = "RotatingIndex";

        private CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(KEY_ROTATING_INDEX, this.rotatingIndex);
            return nbt;
        }

        private static EnergySidedData fromNbt(CompoundTag nbt) {
            EnergySidedData sidedData = new EnergySidedData();
            if (nbt.m_128425_(KEY_ROTATING_INDEX, 3)) {
                sidedData.rotatingIndex = nbt.m_128451_(KEY_ROTATING_INDEX);
            }
            return sidedData;
        }
    }
}

