/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.types.EnergyExtendedData;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.Mergeable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.function.TriFunction;

public class EnergyConduitTicker
extends CapabilityAwareConduitTicker<IEnergyStorage> {
    @Override
    public void tickCapabilityGraph(IConduitType<?> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IEnergyStorage extractHandler = (IEnergyStorage)extract.cap;
            int availableForExtraction = extractHandler.extractEnergy(Integer.MAX_VALUE, true);
            if (availableForExtraction <= 0) continue;
            EnergyExtendedData.EnergySidedData sidedExtractData = extract.data.castTo(EnergyExtendedData.class).compute(extract.direction);
            if (inserts.size() <= sidedExtractData.rotatingIndex) {
                sidedExtractData.rotatingIndex = 0;
            }
            for (int j = sidedExtractData.rotatingIndex; j < sidedExtractData.rotatingIndex + inserts.size(); ++j) {
                int insertIndex = j % inserts.size();
                CapabilityAwareConduitTicker.CapabilityConnection insert = inserts.get(insertIndex);
                int inserted = ((IEnergyStorage)insert.cap).receiveEnergy(availableForExtraction, false);
                extractHandler.extractEnergy(inserted, false);
                if (inserted == availableForExtraction) {
                    sidedExtractData.rotatingIndex += insertIndex + 1;
                    continue block0;
                }
                availableForExtraction -= inserted;
            }
        }
    }

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public Capability<IEnergyStorage> getCapability() {
        return ForgeCapabilities.ENERGY;
    }
}

