/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.ae2;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.conduits.common.integrations.ae2.AE2ConduitType;
import com.enderio.conduits.common.integrations.ae2.GridNodeListener;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class AE2InWorldConduitNodeHost
implements IInWorldGridNodeHost,
IExtendedConduitData<AE2InWorldConduitNodeHost> {
    private final AE2ConduitType type;
    private final IManagedGridNode mainNode;
    final LazyOptional<AE2InWorldConduitNodeHost> selfCap = LazyOptional.of(() -> this);

    public AE2InWorldConduitNodeHost(AE2ConduitType type) {
        this.type = type;
        this.mainNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)new GridNodeListener()).setVisualRepresentation((ItemLike)type.getConduitItem()).setInWorldNode(true).setTagName("conduit");
        if (type.isDense()) {
            this.mainNode.setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        }
        this.mainNode.setIdlePowerUsage(type.isDense() ? 0.4 : 0.1);
    }

    @Nullable
    public IGridNode getGridNode(Direction dir) {
        return this.mainNode.getNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        if (this.type.isDense()) {
            return AECableType.DENSE_SMART;
        }
        return AECableType.SMART;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.mainNode.saveToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.mainNode.loadFromNBT(nbt);
    }

    @Override
    public void onCreated(IConduitType<?> type, Level level, BlockPos pos, @Nullable Player player) {
        if (!this.mainNode.isReady()) {
            if (player != null) {
                this.mainNode.setOwningPlayer(player);
            }
            GridHelper.onFirstTick((BlockEntity)level.m_7702_(pos), blockEntity -> this.mainNode.create(level, pos));
        }
    }

    @Override
    public void updateConnection(Set<Direction> connectedSides) {
        this.mainNode.setExposedOnSides(connectedSides);
    }

    @Override
    public void onRemoved(IConduitType<?> type, Level level, BlockPos pos) {
        this.mainNode.destroy();
        this.selfCap.invalidate();
    }
}

