/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common;

import com.enderio.api.conduit.IConduitType;
import com.enderio.conduits.common.Area;
import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.OffsetHelper;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ConduitShape {
    private final Map<IConduitType<?>, VoxelShape> conduitShapes = new HashMap();
    private final Map<Direction, VoxelShape> directionShapes = new HashMap<Direction, VoxelShape>();
    private static final VoxelShape connector = Block.m_49796_((double)2.5, (double)2.5, (double)15.0, (double)13.5, (double)13.5, (double)16.0);
    private static final VoxelShape connection = Block.m_49796_((double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5, (double)16.0);
    private static final VoxelShape core = Block.m_49796_((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private VoxelShape totalShape = core;

    public void updateConduit(ConduitBundle bundle) {
        this.conduitShapes.clear();
        this.directionShapes.clear();
        for (IConduitType<?> type : bundle.getTypes()) {
            this.updateShapeForConduit(bundle, type);
        }
        this.updateTotalShape();
    }

    public VoxelShape getShapeFromHit(BlockPos pos, HitResult result) {
        return Optional.ofNullable(this.conduitShapes.get(this.getConduit(pos, result))).orElse(Shapes.m_83040_());
    }

    @Nullable
    public IConduitType<?> getConduit(BlockPos pos, HitResult result) {
        return this.getLookUpValue(this.conduitShapes, pos, result);
    }

    @Nullable
    public Direction getDirection(BlockPos pos, HitResult result) {
        return this.getLookUpValue(this.directionShapes, pos, result);
    }

    @Nullable
    private <T> T getLookUpValue(Map<T, VoxelShape> shapes, BlockPos pos, HitResult result) {
        for (Map.Entry<T, VoxelShape> entry : shapes.entrySet()) {
            Vec3 vec3 = result.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            Optional point = entry.getValue().m_166067_(vec3);
            if (point.isEmpty() || !((Vec3)point.get()).m_82509_((Position)vec3, (double)1.0E-5f)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void updateTotalShape() {
        this.totalShape = Shapes.m_83040_();
        this.conduitShapes.values().forEach(s -> {
            this.totalShape = Shapes.m_83113_((VoxelShape)this.totalShape, (VoxelShape)s, (BooleanOp)BooleanOp.f_82695_);
        });
        this.totalShape.m_83296_();
    }

    public VoxelShape getTotalShape() {
        return this.totalShape;
    }

    private void updateShapeForConduit(ConduitBundle conduitBundle, IConduitType<?> conduitType) {
        VoxelShape conduitShape = Shapes.m_83040_();
        Direction.Axis axis = OffsetHelper.findMainAxis(conduitBundle);
        HashMap<IConduitType, List> offsets = new HashMap<IConduitType, List>();
        for (Direction direction : Direction.values()) {
            List<IConduitType<?>> connectedTypes;
            VoxelShape directionShape = this.directionShapes.getOrDefault(direction, Shapes.m_83040_());
            if (conduitBundle.getConnection(direction).getConnectionState(conduitType) instanceof DynamicConnectionState) {
                VoxelShape connectorShape = ConduitShape.rotateVoxelShape(connector, direction);
                directionShape = Shapes.m_83113_((VoxelShape)directionShape, (VoxelShape)connectorShape, (BooleanOp)BooleanOp.f_82695_);
                conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)connectorShape, (BooleanOp)BooleanOp.f_82695_);
            }
            if ((connectedTypes = conduitBundle.getConnection(direction).getConnectedTypes()).contains(conduitType)) {
                Vec3i offset = OffsetHelper.translationFor(direction.m_122434_(), OffsetHelper.offsetConduit(connectedTypes.indexOf(conduitType), connectedTypes.size()));
                offsets.computeIfAbsent(conduitType, ignored -> new ArrayList()).add(offset);
                VoxelShape connectionShape = ConduitShape.rotateVoxelShape(connection, direction).m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f));
                directionShape = Shapes.m_83113_((VoxelShape)directionShape, (VoxelShape)connectionShape, (BooleanOp)BooleanOp.f_82695_);
                conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)connectionShape, (BooleanOp)BooleanOp.f_82695_);
            }
            this.directionShapes.put(direction, directionShape.m_83296_());
        }
        List<IConduitType<?>> allTypes = conduitBundle.getTypes();
        Area box = null;
        HashMap notRendered = new HashMap();
        ArrayList rendered = new ArrayList();
        int i = allTypes.indexOf(conduitType);
        if (i == -1) {
            this.conduitShapes.put(conduitType, Shapes.m_83144_());
            return;
        }
        IConduitType<?> type = allTypes.get(i);
        @Nullable List offsetsForType = (List)offsets.get(type);
        if (offsetsForType != null) {
            if (offsetsForType.stream().distinct().count() == 1L) {
                rendered.add(type);
            } else {
                box = new Area(offsetsForType.toArray(new Vec3i[0]));
            }
        } else {
            notRendered.put(type, i);
        }
        HashSet duplicateFinder = new HashSet();
        List<Vec3i> duplicatePositions = rendered.stream().map(offsets::get).map(l -> (Vec3i)l.get(0)).filter(n -> !duplicateFinder.add(n)).toList();
        for (Vec3i vec3i : duplicatePositions) {
            if (box == null) {
                box = new Area(vec3i);
                continue;
            }
            box.makeContain(vec3i);
        }
        for (IConduitType iConduitType : rendered) {
            if (box != null && box.contains((Vec3i)offsetsForType.get(0))) continue;
            conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)core.m_83216_((double)((float)((Vec3i)offsetsForType.get(0)).m_123341_() * 3.0f / 16.0f), (double)((float)((Vec3i)offsetsForType.get(0)).m_123342_() * 3.0f / 16.0f), (double)((float)((Vec3i)offsetsForType.get(0)).m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
        }
        if (box != null) {
            for (Map.Entry entry : notRendered.entrySet()) {
                Vec3i offset = OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit((Integer)entry.getValue(), allTypes.size()));
                if (box.contains(offset)) continue;
                conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)core.m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
            }
            conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)core.m_83216_((double)((float)box.getMin().m_123341_() * 3.0f / 16.0f), (double)((float)box.getMin().m_123342_() * 3.0f / 16.0f), (double)((float)box.getMin().m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
        } else {
            for (Map.Entry entry : notRendered.entrySet()) {
                Vec3i offset = OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit((Integer)entry.getValue(), allTypes.size()));
                conduitShape = Shapes.m_83113_((VoxelShape)conduitShape, (VoxelShape)core.m_83216_((double)((float)offset.m_123341_() * 3.0f / 16.0f), (double)((float)offset.m_123342_() * 3.0f / 16.0f), (double)((float)offset.m_123343_() * 3.0f / 16.0f)), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        this.conduitShapes.put(conduitType, conduitShape.m_83296_());
    }

    public static VoxelShape rotateVoxelShape(VoxelShape toRotate, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{toRotate, Shapes.m_83040_()};
        if (direction.m_122416_() == -1) {
            if (direction == Direction.DOWN) {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY));
                });
            } else {
                buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minZ, (double)minY, (double)maxX, (double)maxZ, (double)maxY));
                });
            }
            return buffer[1];
        }
        for (int i = 0; i < direction.m_122416_() % 4; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

