/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client.model;

import com.enderio.api.conduit.IConduitType;
import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.base.client.model.PaintingQuadTransformer;
import com.enderio.conduits.client.ConduitClientSetup;
import com.enderio.conduits.client.model.BlockColorQuadDataTransformer;
import com.enderio.conduits.client.model.BoxTextureQuadTransformer;
import com.enderio.conduits.client.model.ColorQuadTransformer;
import com.enderio.conduits.client.model.ConduitTextureEmissiveQuadTransformer;
import com.enderio.conduits.common.Area;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.ConduitConnection;
import com.enderio.conduits.common.blockentity.OffsetHelper;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import com.enderio.conduits.common.blockentity.connection.IConnectionState;
import com.enderio.core.data.model.EIOModel;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ConduitBlockModel
implements IDynamicBakedModel {
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        ConduitBundle conduitBundle = (ConduitBundle)extraData.get(ConduitBlockEntity.BUNDLE_MODEL_PROPERTY);
        BlockPos pos = (BlockPos)extraData.get(ConduitBlockEntity.POS);
        if (conduitBundle != null && pos != null) {
            Direction.Axis axis = OffsetHelper.findMainAxis(conduitBundle);
            HashMap<IConduitType, List> offsets = new HashMap<IConduitType, List>();
            for (Direction direction : Direction.values()) {
                Direction preRotation = ConduitBlockModel.rotateDirection(direction, side);
                ConduitConnection connection = conduitBundle.getConnection(direction);
                IQuadTransformer rotation = QuadTransformers.applying((Transformation)ConduitBlockModel.rotateTransformation(direction));
                if (connection.isEnd()) {
                    quads.addAll(rotation.process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CONNECTOR).getQuads(state, preRotation, rand, extraData, renderType)));
                }
                List<IConduitType<?>> list = connection.getConnectedTypes();
                for (int i = 0; i < list.size(); ++i) {
                    IConduitType<?> type = list.get(i);
                    Vec3i offset = OffsetHelper.translationFor(direction.m_122434_(), OffsetHelper.offsetConduit(i, list.size()));
                    offsets.computeIfAbsent(type, ignored -> new ArrayList()).add(offset);
                    IQuadTransformer rotationTranslation = rotation.andThen(QuadTransformers.applying((Transformation)ConduitBlockModel.translateTransformation(offset)));
                    quads.addAll(new ConduitTextureEmissiveQuadTransformer(ConduitBlockModel.sprite(type, conduitBundle.getNodeFor(type).getExtendedConduitData()), 0).andThen(rotationTranslation).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CONNECTION).getQuads(state, preRotation, rand, extraData, renderType)));
                    quads.addAll(rotationTranslation.process(type.getClientData().createConnectionQuads(conduitBundle.getNodeFor(type).getExtendedConduitData().cast(), side, direction, rand, renderType)));
                    if (!connection.isEnd()) continue;
                    quads.addAll(rotationTranslation.process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CONNECTION_BOX).getQuads(state, preRotation, rand, extraData, renderType)));
                    IConnectionState connectionState = connection.getConnectionState(type);
                    if (!(connectionState instanceof DynamicConnectionState)) continue;
                    DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                    IQuadTransformer color = rotationTranslation.andThen((IQuadTransformer)new ColorQuadTransformer(dyn.insert(), dyn.extract()));
                    BakedModel model = null;
                    if (dyn.isExtract() && dyn.isInsert()) {
                        model = ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_IO_IN_OUT);
                    } else if (dyn.isInsert()) {
                        model = ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_IO_IN);
                    } else if (dyn.isExtract()) {
                        model = ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_IO_OUT);
                    }
                    if (model != null) {
                        quads.addAll(color.process(model.getQuads(state, preRotation, rand, extraData, renderType)));
                    }
                    if (dyn.control() != RedstoneControl.ACTIVE_WITH_SIGNAL && dyn.control() != RedstoneControl.ACTIVE_WITHOUT_SIGNAL) continue;
                    quads.addAll(rotationTranslation.andThen((IQuadTransformer)new ColorQuadTransformer(null, dyn.redstoneChannel())).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_IO_REDSTONE).getQuads(state, preRotation, rand, extraData, renderType)));
                }
                Optional<BlockState> facadeOpt = conduitBundle.getFacade(direction);
                if (!facadeOpt.isPresent()) continue;
                BlockState facade = facadeOpt.get();
                BakedModel facadeModel = Minecraft.m_91087_().m_91289_().m_110910_(facade);
                List textureQuads = facadeModel.getQuads(state, preRotation, rand, ModelData.EMPTY, renderType);
                quads.addAll(rotation.andThen((IQuadTransformer)new BlockColorQuadDataTransformer(pos, (Level)Minecraft.m_91087_().f_91073_, facade)).andThen((IQuadTransformer)new PaintingQuadTransformer(facade, renderType)).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_FACADE).getQuads(state, preRotation, rand, ModelData.EMPTY, renderType)));
            }
            List<IConduitType<?>> allTypes = conduitBundle.getTypes();
            Area box = null;
            HashMap notRendered = new HashMap();
            ArrayList rendered = new ArrayList();
            for (int i = 0; i < allTypes.size(); ++i) {
                IConduitType<?> type = allTypes.get(i);
                @Nullable List offsetsForType = (List)offsets.get(type);
                if (offsetsForType != null) {
                    if (offsetsForType.stream().distinct().count() == 1L) {
                        rendered.add(type);
                        continue;
                    }
                    if (box == null) {
                        box = new Area(offsetsForType.toArray(new Vec3i[0]));
                        continue;
                    }
                    offsetsForType.forEach(box::makeContain);
                    continue;
                }
                notRendered.put(type, i);
            }
            HashSet duplicateFinder = new HashSet();
            List<Vec3i> duplicatePositions = rendered.stream().map(offsets::get).map(l -> (Vec3i)l.get(0)).filter(n -> !duplicateFinder.add(n)).toList();
            for (Vec3i vec3i : duplicatePositions) {
                if (box == null) {
                    box = new Area(vec3i);
                    continue;
                }
                box.makeContain(vec3i);
            }
            for (IConduitType iConduitType : rendered) {
                List offsetsForType = (List)offsets.get(iConduitType);
                if (box != null && box.contains((Vec3i)offsetsForType.get(0))) continue;
                quads.addAll(new ConduitTextureEmissiveQuadTransformer(ConduitBlockModel.sprite(iConduitType, conduitBundle.getNodeFor(iConduitType).getExtendedConduitData()), 0).andThen(QuadTransformers.applying((Transformation)ConduitBlockModel.translateTransformation((Vec3i)offsetsForType.get(0)))).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CORE).getQuads(state, side, rand, extraData, renderType)));
            }
            if (box != null) {
                for (Map.Entry entry : notRendered.entrySet()) {
                    Vec3i offset = OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit((Integer)entry.getValue(), allTypes.size()));
                    if (box.contains(offset)) continue;
                    quads.addAll(new ConduitTextureEmissiveQuadTransformer(ConduitBlockModel.sprite((IConduitType)entry.getKey(), conduitBundle.getNodeFor((IConduitType)entry.getKey()).getExtendedConduitData()), 0).andThen(QuadTransformers.applying((Transformation)ConduitBlockModel.translateTransformation(offset))).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CORE).getQuads(state, side, rand, extraData, renderType)));
                }
                quads.addAll(new BoxTextureQuadTransformer(box.size()).andThen(QuadTransformers.applying((Transformation)ConduitBlockModel.translateTransformation(box.getMin()))).process(ConduitClientSetup.modelOf(ConduitClientSetup.BOX).getQuads(state, side, rand, extraData, renderType)));
            } else {
                for (Map.Entry entry : notRendered.entrySet()) {
                    quads.addAll(new ConduitTextureEmissiveQuadTransformer(ConduitBlockModel.sprite((IConduitType)entry.getKey(), conduitBundle.getNodeFor((IConduitType)entry.getKey()).getExtendedConduitData()), 0).andThen(QuadTransformers.applying((Transformation)ConduitBlockModel.translateTransformation(OffsetHelper.translationFor(axis, OffsetHelper.offsetConduit((Integer)entry.getValue(), allTypes.size()))))).process(ConduitClientSetup.modelOf(ConduitClientSetup.CONDUIT_CORE).getQuads(state, side, rand, extraData, renderType)));
                }
            }
        }
        return quads;
    }

    @Nullable
    public static Direction rotateDirection(Direction toDirection, @Nullable Direction toTransform) {
        if (toTransform == null) {
            return null;
        }
        return switch (toDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> toTransform;
            case Direction.UP -> toTransform.m_175362_(Direction.Axis.Z).m_175362_(Direction.Axis.Z);
            case Direction.NORTH -> toTransform.m_175364_(Direction.Axis.X);
            case Direction.SOUTH -> toTransform.m_175362_(Direction.Axis.X);
            case Direction.WEST -> toTransform.m_175364_(Direction.Axis.Z);
            case Direction.EAST -> toTransform.m_175362_(Direction.Axis.Z);
        };
    }

    public static Transformation rotateTransformation(Direction toDirection) {
        Quaternionf quaternion = new Quaternionf();
        switch (toDirection) {
            case UP: {
                quaternion.mul((Quaternionfc)Axis.f_252403_.m_252977_(180.0f));
                break;
            }
            case NORTH: {
                quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case SOUTH: {
                quaternion.mul((Quaternionfc)Axis.f_252495_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                quaternion.mul((Quaternionfc)Axis.f_252393_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                quaternion.mul((Quaternionfc)Axis.f_252403_.m_252977_(90.0f));
            }
        }
        Transformation transformation = new Transformation(null, quaternion, null, null);
        return transformation.applyOrigin(new Vector3f(0.5f, 0.5f, 0.5f));
    }

    private static Transformation translateTransformation(Vec3i offset) {
        return new Transformation(ConduitBlockModel.scale(offset, 0.1875f), null, null, null);
    }

    private static Vector3f scale(Vec3i vector, float scaler) {
        return new Vector3f((float)vector.m_123341_() * scaler, (float)vector.m_123342_() * scaler, (float)vector.m_123343_() * scaler);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return EIOModel.getMissingTexture();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    private static TextureAtlasSprite sprite(IConduitType<?> type, IExtendedConduitData<?> data) {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(type.getTexture(data.cast()));
    }

    private static boolean isMissingModel(BakedModel model) {
        return model == Minecraft.m_91087_().m_91304_().m_119409_();
    }
}

