/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.loot;

import com.enderio.EnderIO;
import com.enderio.base.common.enchantment.AutoSmeltModifier;
import com.enderio.base.common.init.EIOEnchantments;
import com.enderio.base.common.item.darksteel.upgrades.direct.DirectUpgradeLootCondition;
import com.enderio.base.common.item.darksteel.upgrades.direct.DirectUpgradeLootModifier;
import com.enderio.base.common.loot.BrokenSpawnerLootModifier;
import com.enderio.base.common.loot.ChestLootModifier;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class EIOLootModifiersProvider
extends GlobalLootModifierProvider {
    public EIOLootModifiersProvider(PackOutput output) {
        super(output, "enderio");
    }

    protected void start() {
        this.add("auto_smelt", (IGlobalLootModifier)new AutoSmeltModifier(new LootItemCondition[]{MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate((Enchantment)EIOEnchantments.AUTO_SMELT.get(), MinMaxBounds.Ints.m_55386_((int)1)))).m_6409_()}));
        this.add("broken_spawner", (IGlobalLootModifier)new BrokenSpawnerLootModifier(new LootItemCondition[]{LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50085_).m_6409_()}));
        this.modifyChestLoot("common_loot", Stream.of("chests/abandoned_mineshaft", "chests/buried_treasure", "chests/desert_pyramid", "chests/end_city_treasure", "chests/igloo_chest", "chests/jungle_temple", "chests/jungle_temple_dispenser", "chests/pillager_outpost", "chests/ruined_portal", "chests/shipwreck_map", "chests/shipwreck_supply", "chests/shipwreck_treasure", "chests/simple_dungeon", "chests/stronghold_corridor", "chests/stronghold_crossing", "chests/stronghold_library", "chests/underwater_ruin_big", "chests/underwater_ruin_small", "chests/woodland_mansion"));
        this.modifyChestLoot("alloy_loot", Stream.of("chests/village/village_armorer", "chests/village/village_toolsmith", "chests/village/village_weaponsmith"));
        this.add("direct_upgrade", (IGlobalLootModifier)new DirectUpgradeLootModifier(new LootItemCondition[]{new DirectUpgradeLootCondition()}));
    }

    private void modifyChestLoot(String modifierName, Stream<String> targets) {
        LootTableIdCondition.Builder[] mappedTargetConditions = (LootTableIdCondition.Builder[])targets.map(r -> LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(r))).toArray(LootTableIdCondition.Builder[]::new);
        this.add(modifierName, (IGlobalLootModifier)new ChestLootModifier(new LootItemCondition[]{AnyOfCondition.m_285758_((LootItemCondition.Builder[])mappedTargetConditions).m_6409_()}, EnderIO.loc("chests/" + modifierName)));
    }
}

