/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import com.enderio.api.grindingball.IGrindingBallData;
import com.enderio.base.common.init.EIORecipes;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class GrindingBallManager {
    private static final HashMap<Item, IGrindingBallData> itemToData = new HashMap();
    private static final HashMap<ResourceLocation, IGrindingBallData> idToData = new HashMap();
    private static boolean clearCache = false;

    public static boolean isGrindingBall(ItemStack stack) {
        GrindingBallManager.checkCacheRebuild();
        return !stack.m_41619_() && itemToData.containsKey(stack.m_41720_());
    }

    public static IGrindingBallData getData(ItemStack stack) {
        GrindingBallManager.checkCacheRebuild();
        Item item = stack.m_41720_();
        return itemToData.getOrDefault(item, IGrindingBallData.IDENTITY);
    }

    public static List<Item> getGrindingBalls() {
        GrindingBallManager.checkCacheRebuild();
        return List.copyOf(itemToData.keySet());
    }

    public static IGrindingBallData getData(ResourceLocation dataId) {
        GrindingBallManager.checkCacheRebuild();
        return idToData.getOrDefault(dataId, IGrindingBallData.IDENTITY);
    }

    @SubscribeEvent
    public static void registerReloadListener(AddReloadListenerEvent event) {
        clearCache = true;
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        GrindingBallManager.rebuildCache(event.getRecipeManager());
    }

    private static void checkCacheRebuild() {
        if (clearCache && EffectiveSide.get().isServer()) {
            GrindingBallManager.rebuildCache(ServerLifecycleHooks.getCurrentServer().m_129894_());
            clearCache = false;
        }
    }

    private static void rebuildCache(RecipeManager manager) {
        itemToData.clear();
        idToData.clear();
        manager.m_44013_((RecipeType)EIORecipes.GRINDING_BALL.type().get()).forEach(grindingBallRecipe -> {
            itemToData.put(grindingBallRecipe.getItem(), (IGrindingBallData)grindingBallRecipe);
            idToData.put(grindingBallRecipe.getGrindingBallId(), (IGrindingBallData)grindingBallRecipe);
        });
    }
}

