/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import com.enderio.api.misc.Vector2i;
import net.minecraft.world.entity.player.Player;

public class ExperienceUtil {
    public static int EXP_TO_FLUID = 20;

    public static Vector2i getLevelForExpWithLeftover(int experience, int startLevel, int stopLevel) {
        int expNeeded = ExperienceUtil.getXpNeededForNextLevel(startLevel);
        if (expNeeded < experience && startLevel < stopLevel) {
            return ExperienceUtil.getLevelForExpWithLeftover(experience -= expNeeded, ++startLevel, stopLevel);
        }
        return new Vector2i(startLevel, experience);
    }

    public static Vector2i getLevelFromFluidWithLeftover(int fluidAmount, int startLevel, int stopLevel) {
        Vector2i res = ExperienceUtil.getLevelForExpWithLeftover(fluidAmount / EXP_TO_FLUID, startLevel, stopLevel);
        return res.add(fluidAmount % EXP_TO_FLUID, 0);
    }

    public static Vector2i getLevelFromFluidWithLeftover(int fluidAmount) {
        return ExperienceUtil.getLevelForExpWithLeftover(fluidAmount / EXP_TO_FLUID, 0, Integer.MAX_VALUE);
    }

    public static int getLevelFromFluid(int fluidAmount) {
        return ExperienceUtil.getLevelFromFluidWithLeftover(fluidAmount).x();
    }

    public static int getLevelFromFluid(int fluidAmount, int startLevel, int stopLevel) {
        return ExperienceUtil.getLevelFromFluidWithLeftover(fluidAmount, startLevel, stopLevel).x();
    }

    private static int getLevelForExp(int experience, int startLevel, int stopLevel) {
        return ExperienceUtil.getLevelForExpWithLeftover(experience, startLevel, stopLevel).x();
    }

    public static int getExpFromLevel(int level) {
        int leftover = ExperienceUtil.getLevelForExpWithLeftover(Integer.MAX_VALUE, 0, level).y();
        return Integer.MAX_VALUE - leftover;
    }

    public static int getFluidFromLevel(int level) {
        return ExperienceUtil.getExpFromLevel(level) * EXP_TO_FLUID;
    }

    public static int getPlayerTotalXp(Player player) {
        return ExperienceUtil.getExpFromLevel(player.f_36078_) + (int)Math.floor(player.f_36080_ * (float)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_ + 1));
    }

    public static int getXpNeededForNextLevel(int explevel) {
        if (explevel >= 30) {
            return 112 + (explevel - 30) * 9;
        }
        return explevel >= 15 ? 37 + (explevel - 15) * 5 : 7 + explevel * 2;
    }
}

