/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.darksteel.upgrades.explosive;

import com.enderio.base.common.capability.DarkSteelUpgradeable;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.item.darksteel.upgrades.explosive.ExplosivePenetrationUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.explosive.ExplosiveUpgrade;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.network.EmitParticlesPacket;
import com.enderio.core.common.util.BlockUtil;
import com.enderio.core.common.util.EnergyUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExplosiveUpgradeHandler {
    private static final ForgeConfigSpec.ConfigValue<Integer> EXPLOSIVE_BREAK_POWER_USE = BaseConfig.COMMON.DARK_STEEL.EXPLOSIVE_ENERGY_PER_EXPLODED_BLOCK;
    private static final Random RAND = new Random();

    public static boolean hasExplosiveUpgrades(ItemStack stack) {
        return DarkSteelUpgradeable.hasUpgrade(stack, "enderio.darksteel.upgrade.explosive") || DarkSteelUpgradeable.hasUpgrade(stack, "enderio.darksteel.upgrade.explosive_penetration");
    }

    public static void onMineBlock(ItemStack pStack, Level pLevel, BlockPos pPos, LivingEntity pEntityLiving) {
        EmitParticlesPacket particles;
        BlockHitResult hit;
        Player player;
        if (pEntityLiving instanceof Player && !(player = (Player)pEntityLiving).m_6047_() && ExplosiveUpgradeHandler.hasExplosiveUpgrades(pStack) && EnergyUtil.getEnergyStored(pStack) > 0 && pPos.equals((Object)(hit = Item.m_41435_((Level)pLevel, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)).m_82425_()) && ExplosiveUpgradeHandler.explodeArea(pStack, pLevel, player, hit, particles = new EmitParticlesPacket())) {
            CoreNetwork.sendToTracking(pLevel.m_46745_(pPos), particles);
        }
    }

    private static boolean explodeArea(ItemStack pStack, Level pLevel, Player player, BlockHitResult hit, EmitParticlesPacket particles) {
        boolean didExplode = false;
        AABB bb = ExplosiveUpgradeHandler.calculateMiningArea(pStack, hit.m_82434_());
        bb = bb.m_82338_(hit.m_82425_());
        for (BlockPos minePos : BlockPos.m_121976_((int)((int)bb.f_82288_), (int)((int)bb.f_82289_), (int)((int)bb.f_82290_), (int)((int)bb.f_82291_ - 1), (int)((int)bb.f_82292_ - 1), (int)((int)bb.f_82293_ - 1))) {
            if (hit.m_82425_().equals((Object)minePos)) continue;
            didExplode = ExplosiveUpgradeHandler.explodeBlock(pStack, pLevel, minePos, player, particles) || didExplode;
        }
        return didExplode;
    }

    private static boolean explodeBlock(ItemStack itemStack, Level level, BlockPos minePos, Player player, EmitParticlesPacket particles) {
        if (!level.m_46739_(minePos) || EnergyUtil.getEnergyStored(itemStack) <= 0) {
            return false;
        }
        BlockState blockState = level.m_8055_(minePos);
        if (!ExplosiveUpgradeHandler.canExplode(itemStack, blockState, level.m_7702_(minePos))) {
            return false;
        }
        if (BlockUtil.removeBlock(level, player, itemStack, minePos)) {
            EnergyUtil.extractEnergy(itemStack, (Integer)EXPLOSIVE_BREAK_POWER_USE.get(), false);
            if (RAND.nextFloat() < 0.3f) {
                particles.add(minePos, (ParticleOptions)ParticleTypes.f_123755_);
            } else if (RAND.nextFloat() < 0.7f) {
                particles.add(minePos, (ParticleOptions)ParticleTypes.f_123762_);
            }
            return true;
        }
        return false;
    }

    private static boolean canExplode(ItemStack itemStack, BlockState blockState, @Nullable BlockEntity blockEntity) {
        if (blockState.m_204336_(EIOTags.Blocks.DARK_STEEL_EXPLODABLE_ALLOW_LIST)) {
            return true;
        }
        if (blockState.m_204336_(EIOTags.Blocks.DARK_STEEL_EXPLODABLE_DENY_LIST) || blockEntity != null) {
            return false;
        }
        return Items.f_42427_.m_8096_(blockState) || DarkSteelUpgradeable.hasUpgrade(itemStack, "enderio.darksteel.upgrade.spoon") && Items.f_42426_.m_8096_(blockState);
    }

    public static float adjustDestroySpeed(float inputSpeed, ItemStack pStack) {
        if (ExplosiveUpgradeHandler.hasExplosiveUpgrades(pStack) && EnergyUtil.getEnergyStored(pStack) > 0) {
            float maxReductionRatio = 0.5f;
            float areaAtMaxReduction = 75.0f;
            AABB bounds = ExplosiveUpgradeHandler.calculateMiningArea(pStack, Direction.NORTH);
            float miningArea = (float)(bounds.m_82362_() * bounds.m_82376_() * bounds.m_82385_());
            float adjustBy = miningArea / areaAtMaxReduction * maxReductionRatio;
            adjustBy = Math.min(adjustBy, maxReductionRatio);
            return inputSpeed - inputSpeed * adjustBy;
        }
        return inputSpeed;
    }

    private static AABB calculateMiningArea(ItemStack tool, Direction targetDir) {
        int penetration;
        AABB miningBounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        int radius = DarkSteelUpgradeable.getUpgradeAs(tool, "enderio.darksteel.upgrade.explosive", ExplosiveUpgrade.class).map(ExplosiveUpgrade::getMagnitude).orElse(0);
        if (radius > 0) {
            Vector3d mask = new Vector3d(targetDir.m_122429_() == 0 ? (double)radius : 0.0, targetDir.m_122430_() == 0 ? (double)radius : 0.0, targetDir.m_122431_() == 0 ? (double)radius : 0.0);
            miningBounds = miningBounds.m_82363_(mask.x, mask.y, mask.z);
            miningBounds = miningBounds.m_82363_(-mask.x, -mask.y, -mask.z);
        }
        if ((penetration = DarkSteelUpgradeable.getUpgradeAs(tool, "enderio.darksteel.upgrade.explosive_penetration", ExplosivePenetrationUpgrade.class).map(ExplosivePenetrationUpgrade::getMagnitude).orElse(0).intValue()) > 0) {
            Vec3i shiftDir = targetDir.m_122436_();
            shiftDir = shiftDir.m_142393_(-1);
            miningBounds = miningBounds.m_82363_((double)(penetration * shiftDir.m_123341_()), (double)(penetration * shiftDir.m_123342_()), (double)(penetration * shiftDir.m_123343_()));
        }
        return miningBounds;
    }

    @SubscribeEvent
    public static void showAreaOfEffectHighlight(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_6047_() && ExplosiveUpgradeHandler.hasExplosiveUpgrades(player.m_21120_(InteractionHand.MAIN_HAND))) {
            ExplosiveUpgradeHandler.drawHighlight(event, player.m_21120_(InteractionHand.MAIN_HAND));
        }
    }

    private static void drawHighlight(RenderHighlightEvent.Block event, ItemStack held) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos blockPos = event.getTarget().m_82425_();
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60795_() || !level.m_6857_().m_61937_(blockPos)) {
            return;
        }
        AABB miningBounds = ExplosiveUpgradeHandler.calculateMiningArea(held, event.getTarget().m_82434_());
        VoxelShape outlineShape = Shapes.m_83064_((AABB)miningBounds);
        VertexConsumer vertexConsumer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        PoseStack poseStack = event.getPoseStack();
        Vec3 camPos = event.getCamera().m_90583_();
        Vector3d origin = new Vector3d((double)blockPos.m_123341_() - camPos.m_7096_(), (double)blockPos.m_123342_() - camPos.m_7098_(), (double)blockPos.m_123343_() - camPos.m_7094_());
        Vector4f color = new Vector4f(1.0f, 0.0f, 0.0f, 0.2f);
        ExplosiveUpgradeHandler.renderShape(poseStack, vertexConsumer, outlineShape, origin, color);
        AABB refBounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        color = new Vector4f(0.0f, 0.0f, 0.0f, 0.2f);
        ExplosiveUpgradeHandler.renderJoiningLines(poseStack, vertexConsumer, refBounds, miningBounds, origin, color);
    }

    private static void renderJoiningLines(PoseStack poseStack, VertexConsumer vertexConsumer, AABB refBounds, AABB miningBounds, Vector3d origin, Vector4f color) {
        List<Vector3d> fromCorners = ExplosiveUpgradeHandler.getCorners(refBounds);
        List<Vector3d> toCorners = ExplosiveUpgradeHandler.getCorners(miningBounds);
        for (int i = 0; i < fromCorners.size(); ++i) {
            Vector3d from = fromCorners.get(i);
            Vector3d to = toCorners.get(i);
            ExplosiveUpgradeHandler.addVertices(poseStack.m_85850_(), vertexConsumer, origin, from, to, color);
        }
    }

    private static List<Vector3d> getCorners(AABB aabb) {
        ArrayList<Vector3d> res = new ArrayList<Vector3d>(8);
        res.add(new Vector3d(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_));
        res.add(new Vector3d(aabb.f_82288_, aabb.f_82292_, aabb.f_82290_));
        res.add(new Vector3d(aabb.f_82291_, aabb.f_82289_, aabb.f_82290_));
        res.add(new Vector3d(aabb.f_82291_, aabb.f_82292_, aabb.f_82290_));
        res.add(new Vector3d(aabb.f_82288_, aabb.f_82289_, aabb.f_82293_));
        res.add(new Vector3d(aabb.f_82288_, aabb.f_82292_, aabb.f_82293_));
        res.add(new Vector3d(aabb.f_82291_, aabb.f_82289_, aabb.f_82293_));
        res.add(new Vector3d(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_));
        return res;
    }

    private static void renderShape(PoseStack pPoseStack, VertexConsumer pConsumer, VoxelShape pShape, Vector3d origin, Vector4f color) {
        PoseStack.Pose pose = pPoseStack.m_85850_();
        pShape.m_83224_((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> ExplosiveUpgradeHandler.addVertices(pose, pConsumer, origin.x, origin.y, origin.z, pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ, color));
    }

    private static void addVertices(PoseStack.Pose pose, VertexConsumer pConsumer, Vector3d origin, Vector3d from, Vector3d to, Vector4f color) {
        ExplosiveUpgradeHandler.addVertices(pose, pConsumer, origin.x, origin.y, origin.z, from.x, from.y, from.z, to.x, to.y, to.z, color);
    }

    private static void addVertices(PoseStack.Pose pose, VertexConsumer pConsumer, double originX, double originY, double originZ, double fromX, double fromY, double fromZ, double toX, double toY, double toZ, Vector4f color) {
        float normalX = (float)(toX - fromX);
        float normalY = (float)(toY - fromY);
        float normalZ = (float)(toZ - fromZ);
        float length = Mth.m_14116_((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        pConsumer.m_252986_(pose.m_252922_(), (float)(fromX + originX), (float)(fromY + originY), (float)(fromZ + originZ)).m_85950_(color.x(), color.y(), color.z(), color.w()).m_252939_(pose.m_252943_(), normalX /= length, normalY /= length, normalZ /= length).m_5752_();
        pConsumer.m_252986_(pose.m_252922_(), (float)(toX + originX), (float)(toY + originY), (float)(toZ + originZ)).m_85950_(color.x(), color.y(), color.z(), color.w()).m_252939_(pose.m_252943_(), normalX, normalY, normalZ).m_5752_();
    }
}

