/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.darksteel.upgrades;

import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.item.darksteel.upgrades.EmpoweredUpgradeTier;
import com.enderio.base.common.item.darksteel.upgrades.TieredUpgrade;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.common.util.TooltipUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EmpoweredUpgrade
extends TieredUpgrade<EmpoweredUpgradeTier> {
    public static final String NAME = "enderio.darksteel.upgrade.empowered";
    public static final String STORAGE_KEY = "storage";
    private static final Random RANDOM = new Random();
    private final ForgeConfigSpec.ConfigValue<Integer> speedBoostWhenPowered;
    private final ForgeConfigSpec.ConfigValue<Integer> powerUsePerDamagePoint;
    @Nullable
    private EnergyStorage storage;

    public EmpoweredUpgrade() {
        this(EmpoweredUpgradeTier.ONE);
    }

    public EmpoweredUpgrade(EmpoweredUpgradeTier tier) {
        super(tier, NAME);
        this.speedBoostWhenPowered = BaseConfig.COMMON.DARK_STEEL.EMPOWERED_EFFICIENCY_BOOST;
        this.powerUsePerDamagePoint = BaseConfig.COMMON.DARK_STEEL.EMPOWERED_ENERGY_PER_DAMAGE;
        this.storage = null;
    }

    public float adjustDestroySpeed(float speed) {
        if (this.getStorage().getEnergyStored() > 0) {
            speed += (float)((Integer)this.speedBoostWhenPowered.get()).intValue();
        }
        return speed;
    }

    public int adjustDamage(int oldDamage, int newDamage) {
        int damageTaken = newDamage - oldDamage;
        if (damageTaken > 0 && this.getStorage().getEnergyStored() > 0 && RANDOM.nextDouble() < (double)((EmpoweredUpgradeTier)this.tier).getDamageAbsorptionChance()) {
            this.getStorage().extractEnergy(damageTaken * (Integer)this.powerUsePerDamagePoint.get(), false);
            return oldDamage;
        }
        return newDamage;
    }

    public EnergyStorage getStorage() {
        return this.storage != null ? this.storage : new EnergyStorage(((EmpoweredUpgradeTier)this.tier).getMaxStorage());
    }

    @Override
    public Collection<Component> getDescription() {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(EIOLang.DS_UPGRADE_EMPOWERED_DESCRIPTION);
        result.add((Component)TooltipUtil.withArgs(EIOLang.DS_UPGRADE_EMPOWERED_STORAGE, String.format("%,d", ((EmpoweredUpgradeTier)this.tier).getMaxStorage())));
        result.add((Component)TooltipUtil.withArgs(EIOLang.DS_UPGRADE_EMPOWERED_DAMAGE_ABSORPTION, (int)(((EmpoweredUpgradeTier)this.tier).getDamageAbsorptionChance() * 100.0f)));
        return result;
    }

    @Override
    protected EmpoweredUpgradeTier getBaseTier() {
        return EmpoweredUpgradeTier.ONE;
    }

    @Override
    protected Optional<EmpoweredUpgradeTier> getTier(int tier) {
        if (tier >= EmpoweredUpgradeTier.values().length || tier < 0) {
            return Optional.empty();
        }
        return Optional.of(EmpoweredUpgradeTier.values()[tier]);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128365_(STORAGE_KEY, this.getStorage().serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(Tag tag) {
        super.deserializeNBT(tag);
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.storage = new EnergyStorage(((EmpoweredUpgradeTier)this.tier).getMaxStorage());
            this.storage.deserializeNBT(nbt.m_128423_(STORAGE_KEY));
        }
    }
}

