/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.darksteel.upgrades;

import com.enderio.api.capability.IDarkSteelUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.EmpoweredUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.ForkUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.SpoonUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.direct.DirectUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.explosive.ExplosivePenetrationUpgrade;
import com.enderio.base.common.item.darksteel.upgrades.explosive.ExplosiveUpgrade;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class DarkSteelUpgradeRegistry {
    public static final String UPGRADE_PREFIX = "enderio.darksteel.upgrade.";
    private static final DarkSteelUpgradeRegistry INST = new DarkSteelUpgradeRegistry();
    private static final String UPGRADE_IN_STACK_KEY = "dark_steel_upgrade";
    private final Map<String, Supplier<IDarkSteelUpgrade>> registeredUpgrades = new HashMap<String, Supplier<IDarkSteelUpgrade>>();
    private final Map<ResourceLocation, Set<String>> possibleUpgrades = new HashMap<ResourceLocation, Set<String>>();

    public static DarkSteelUpgradeRegistry instance() {
        return INST;
    }

    private DarkSteelUpgradeRegistry() {
    }

    public void registerUpgrade(String upgradeName, Supplier<IDarkSteelUpgrade> upgrade) {
        this.registeredUpgrades.put(upgradeName, upgrade);
    }

    public Optional<IDarkSteelUpgrade> createUpgrade(String name) {
        Supplier<IDarkSteelUpgrade> val = this.registeredUpgrades.get(name);
        if (val == null) {
            return Optional.empty();
        }
        return Optional.of(val.get());
    }

    public void writeUpgradeToItemStack(ItemStack stack, IDarkSteelUpgrade upgrade) {
        CompoundTag rootTag = new CompoundTag();
        rootTag.m_128359_("name", upgrade.getName());
        rootTag.m_128365_("data", upgrade.serializeNBT());
        stack.m_41784_().m_128365_(UPGRADE_IN_STACK_KEY, (Tag)rootTag);
    }

    public boolean hasUpgrade(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return false;
        }
        return stack.m_41784_().m_128441_(UPGRADE_IN_STACK_KEY);
    }

    public Optional<IDarkSteelUpgrade> readUpgradeFromStack(ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41782_()) {
            return Optional.empty();
        }
        Tag upTag = stack.m_41784_().m_128423_(UPGRADE_IN_STACK_KEY);
        if (upTag instanceof CompoundTag) {
            CompoundTag rootTag = (CompoundTag)upTag;
            String serName = rootTag.m_128461_("name");
            Optional<IDarkSteelUpgrade> upgrade = this.createUpgrade(serName);
            return upgrade.map(up -> {
                up.deserializeNBT(Objects.requireNonNull(rootTag.m_128423_("data")));
                return upgrade;
            }).orElse(Optional.empty());
        }
        return Optional.empty();
    }

    public void addUpgradesForItem(ResourceLocation forItem, String ... upgrades) {
        Set currentValues = this.possibleUpgrades.getOrDefault(forItem, new HashSet());
        Collections.addAll(currentValues, upgrades);
        this.possibleUpgrades.put(forItem, currentValues);
    }

    public Set<String> getUpgradesForItem(ResourceLocation forItem) {
        return Collections.unmodifiableSet(this.possibleUpgrades.getOrDefault(forItem, Collections.emptySet()));
    }

    static {
        INST.registerUpgrade("enderio.darksteel.upgrade.empowered", EmpoweredUpgrade::new);
        INST.registerUpgrade("enderio.darksteel.upgrade.spoon", SpoonUpgrade::new);
        INST.registerUpgrade("enderio.darksteel.upgrade.fork", ForkUpgrade::new);
        INST.registerUpgrade("enderio.darksteel.upgrade.direct", DirectUpgrade::new);
        INST.registerUpgrade("enderio.darksteel.upgrade.explosive", ExplosiveUpgrade::new);
        INST.registerUpgrade("enderio.darksteel.upgrade.explosive_penetration", ExplosivePenetrationUpgrade::new);
    }
}

