/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.darksteel;

import com.enderio.api.capability.IDarkSteelUpgrade;
import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.capability.DarkSteelUpgradeable;
import com.enderio.base.common.capability.EnergyDelegator;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.item.darksteel.upgrades.EmpoweredUpgrade;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.IAdvancedTooltipProvider;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public interface IDarkSteelItem
extends IMultiCapabilityItem,
IAdvancedTooltipProvider,
ITabVariants {
    default public Optional<EmpoweredUpgrade> getEmpoweredUpgrade(ItemStack stack) {
        return DarkSteelUpgradeable.getUpgradeAs(stack, "enderio.darksteel.upgrade.empowered", EmpoweredUpgrade.class);
    }

    @Override
    default public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        return this.initDarkSteelCapabilities(provider, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
    }

    default public MultiCapabilityProvider initDarkSteelCapabilities(MultiCapabilityProvider provider, ResourceLocation forItem) {
        provider.add(EIOCapabilities.DARK_STEEL_UPGRADABLE, LazyOptional.of(() -> new DarkSteelUpgradeable(forItem)));
        provider.add(ForgeCapabilities.ENERGY, LazyOptional.of(() -> new EnergyDelegator(provider)));
        return provider;
    }

    default public ItemStack createFullyUpgradedStack(Item item) {
        ItemStack is = new ItemStack((ItemLike)item);
        Collection<IDarkSteelUpgrade> ups = DarkSteelUpgradeable.getAllPossibleUpgrades(is);
        Iterator<IDarkSteelUpgrade> iterator = ups.iterator();
        while (iterator.hasNext()) {
            IDarkSteelUpgrade upgrade;
            IDarkSteelUpgrade maxTier = upgrade = iterator.next();
            Optional<? extends IDarkSteelUpgrade> nextTier = maxTier.getNextTier();
            while (nextTier.isPresent()) {
                maxTier = nextTier.get();
                nextTier = maxTier.getNextTier();
            }
            DarkSteelUpgradeable.addUpgrade(is, maxTier);
        }
        EnergyUtil.setFull(is);
        return is;
    }

    @Override
    default public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
    }

    @Override
    default public void addBasicTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        this.addCurrentUpgradeTooltips(itemStack, tooltips, false);
    }

    @Override
    default public void addDetailedTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        this.addDurabilityTooltips(itemStack, tooltips);
        this.addCurrentUpgradeTooltips(itemStack, tooltips, true);
        this.addAvailableUpgradesTooltips(itemStack, tooltips);
    }

    default public void addDurabilityTooltips(ItemStack itemStack, List<Component> tooltips) {
        if (itemStack.m_41763_()) {
            String durability = itemStack.m_41776_() - itemStack.m_41773_() + "/" + itemStack.m_41776_();
            tooltips.add((Component)TooltipUtil.withArgs(EIOLang.DURABILITY_AMOUNT, durability).m_130940_(ChatFormatting.GRAY));
        }
        if (DarkSteelUpgradeable.hasUpgrade(itemStack, "enderio.darksteel.upgrade.empowered")) {
            String energy = String.format("%,d", EnergyUtil.getEnergyStored(itemStack)) + "/" + String.format("%,d", EnergyUtil.getMaxEnergyStored(itemStack));
            tooltips.add((Component)TooltipUtil.withArgs(EIOLang.ENERGY_AMOUNT, energy).m_130940_(ChatFormatting.GRAY));
        }
    }

    default public void addCurrentUpgradeTooltips(ItemStack itemStack, List<Component> tooltips, boolean isDetailed) {
        Collection<IDarkSteelUpgrade> upgrades = DarkSteelUpgradeable.getUpgrades(itemStack);
        upgrades.stream().sorted(Comparator.comparing(IDarkSteelUpgrade::getName)).forEach(upgrade -> tooltips.add(1, (Component)upgrade.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
    }

    default public void addAvailableUpgradesTooltips(ItemStack itemStack, List<Component> tooltips) {
        Collection<IDarkSteelUpgrade> availUpgrades = DarkSteelUpgradeable.getUpgradesApplicable(itemStack);
        if (!availUpgrades.isEmpty()) {
            tooltips.add((Component)EIOLang.DS_UPGRADE_AVAILABLE.m_6881_().m_130940_(ChatFormatting.YELLOW));
            availUpgrades.stream().sorted(Comparator.comparing(IDarkSteelUpgrade::getName)).forEach(upgrade -> tooltips.add((Component)Component.m_237113_((String)(" " + upgrade.getDisplayName().getString())).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.ITALIC})));
        }
    }

    default public boolean isDurabilityBarVisible(ItemStack stack) {
        return stack.m_41773_() > 0 || EnergyUtil.getMaxEnergyStored(stack) > 0;
    }
}

