/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.darksteel;

import com.enderio.base.common.capability.DarkSteelUpgradeable;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.item.darksteel.IDarkSteelItem;
import com.enderio.base.common.item.darksteel.upgrades.explosive.ExplosiveUpgradeHandler;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class DarkSteelPickaxeItem
extends PickaxeItem
implements IDarkSteelItem,
ITabVariants {
    private final ForgeConfigSpec.ConfigValue<Integer> obsidianBreakPowerUse;
    private final ForgeConfigSpec.ConfigValue<Integer> speedBoostWhenObsidian;
    private final ForgeConfigSpec.ConfigValue<Integer> useObsidianBreakSpeedAtHardness;

    public DarkSteelPickaxeItem(Item.Properties pProperties) {
        super(EIOItems.DARK_STEEL_TIER, 1, -2.8f, pProperties);
        this.obsidianBreakPowerUse = BaseConfig.COMMON.DARK_STEEL.DARK_STEEL_PICKAXE_OBSIDIAN_ENERGY_COST;
        this.speedBoostWhenObsidian = BaseConfig.COMMON.DARK_STEEL.DARK_STEEL_PICKAXE_OBSIDIAN_SPEED;
        this.useObsidianBreakSpeedAtHardness = BaseConfig.COMMON.DARK_STEEL.DARK_STEEL_PICKAXE_AS_OBSIDIAN_AT_HARDNESS;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int finalDamage = this.getEmpoweredUpgrade(stack).map(empoweredUpgrade -> empoweredUpgrade.adjustDamage(this.getDamage(stack), newDamage)).orElse(newDamage);
        super.setDamage(stack, finalDamage);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        float baseSpeed = this.canHarvest(pStack, pState) ? this.f_40980_ : 1.0f;
        float adjustedSpeed = this.getEmpoweredUpgrade(pStack).map(empoweredUpgrade -> Float.valueOf(empoweredUpgrade.adjustDestroySpeed(baseSpeed))).orElse(Float.valueOf(baseSpeed)).floatValue();
        adjustedSpeed = ExplosiveUpgradeHandler.adjustDestroySpeed(adjustedSpeed, pStack);
        if (this.useObsidianMining(pState, pStack)) {
            adjustedSpeed += (float)((Integer)this.speedBoostWhenObsidian.get()).intValue();
        }
        return adjustedSpeed;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (this.useObsidianMining(pState, pStack)) {
            EnergyUtil.extractEnergy(pStack, (Integer)this.obsidianBreakPowerUse.get(), false);
        }
        ExplosiveUpgradeHandler.onMineBlock(pStack, pLevel, pPos, pEntityLiving);
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.canHarvest(stack, state) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.m_43314_(), (BlockState)state);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        if (this.hasSpoon(pContext.m_43722_())) {
            return Items.f_42389_.m_6225_(pContext);
        }
        return super.m_6225_(pContext);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return super.canPerformAction(stack, toolAction) || this.hasSpoon(stack) && ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction);
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        modifier.m_246342_(this.createFullyUpgradedStack((Item)this));
        ItemStack itemStack = this.createFullyUpgradedStack((Item)this);
        DarkSteelUpgradeable.removeUpgrade(itemStack, "enderio.darksteel.upgrade.explosive");
        DarkSteelUpgradeable.removeUpgrade(itemStack, "enderio.darksteel.upgrade.explosive_penetration");
        modifier.m_246342_(itemStack);
    }

    private boolean canHarvest(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144283_) && this.hasSpoon(stack);
    }

    private boolean hasSpoon(ItemStack stack) {
        return DarkSteelUpgradeable.hasUpgrade(stack, "enderio.darksteel.upgrade.spoon");
    }

    private boolean useObsidianMining(BlockState pState, ItemStack stack) {
        return EnergyUtil.getEnergyStored(stack) >= (Integer)this.obsidianBreakPowerUse.get() && this.treatBlockAsObsidian(pState);
    }

    private boolean treatBlockAsObsidian(BlockState pState) {
        return pState.m_60734_() == Blocks.f_50080_ || (Integer)this.useObsidianBreakSpeedAtHardness.get() > 0 && pState.m_60734_().m_155943_() >= (float)((Integer)this.useObsidianBreakSpeedAtHardness.get()).intValue();
    }

    @Override
    public void addCurrentUpgradeTooltips(ItemStack itemStack, List<Component> tooltips, boolean isDetailed) {
        if (isDetailed && this.getEmpoweredUpgrade(itemStack).isPresent()) {
            tooltips.add((Component)TooltipUtil.withArgs(EIOLang.DS_UPGRADE_EMPOWERED_EFFICIENCY, BaseConfig.COMMON.DARK_STEEL.EMPOWERED_EFFICIENCY_BOOST.get()));
            tooltips.add((Component)TooltipUtil.withArgs(EIOLang.DS_UPGRADE_EMPOWERED_OBSIDIAM_EFFICIENCY, this.speedBoostWhenObsidian.get()));
        }
        IDarkSteelItem.super.addCurrentUpgradeTooltips(itemStack, tooltips, isDetailed);
    }

    public boolean m_5812_(ItemStack pStack) {
        return DarkSteelUpgradeable.hasUpgrade(pStack, "enderio.darksteel.upgrade.empowered");
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.isDurabilityBarVisible(pStack);
    }
}

