/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.hangglider;

import com.enderio.api.glider.GliderMovementInfo;
import com.enderio.api.integration.IntegrationManager;
import com.enderio.base.common.advancement.UseGliderTrigger;
import com.enderio.base.common.lang.EIOLang;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerMovementHandler {
    private static final double AIR_FRICTION_COEFFICIENT = 1.0989010989010988;
    private static final double MOVEMENT_CHANGE_EFFECT = 0.05;
    private static final Map<Player, Integer> TICKS_FALLING = new WeakHashMap<Player, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        Player player = playerTickEvent.player;
        if (playerTickEvent.phase == TickEvent.Phase.START) {
            int ticksFalling = TICKS_FALLING.getOrDefault(player, 0);
            if (player.m_20096_() != player.m_20184_().m_7098_() < 0.0) {
                TICKS_FALLING.put(player, ticksFalling + 1);
            } else {
                TICKS_FALLING.put(player, 0);
            }
            if (player.m_5833_()) {
                return;
            }
            Optional<GliderMovementInfo> gliderMovementInfoOpt = PlayerMovementHandler.calculateGliderMovementInfo(player, true);
            if (gliderMovementInfoOpt.isEmpty()) {
                return;
            }
            GliderMovementInfo gliderMovementInfo = gliderMovementInfoOpt.get();
            double verticalSpeed = gliderMovementInfo.fallSpeed();
            if (player.m_20142_()) {
                verticalSpeed *= 3.0;
            }
            double oldHorizontalSpeed = player.m_20184_().m_165924_();
            double x = Math.cos(Math.toRadians(player.f_20885_ + 90.0f)) * (gliderMovementInfo.acceleration() + oldHorizontalSpeed * 0.05);
            double z = Math.sin(Math.toRadians(player.f_20885_ + 90.0f)) * (gliderMovementInfo.acceleration() + oldHorizontalSpeed * 0.05);
            Vec3 newDeltaMovement = new Vec3(player.m_20184_().m_7096_() * 0.95 + x, verticalSpeed, player.m_20184_().m_7094_() * 0.95 + z);
            double speed = newDeltaMovement.m_82553_();
            if (speed > gliderMovementInfo.maxSpeed()) {
                newDeltaMovement = newDeltaMovement.m_82490_(gliderMovementInfo.maxSpeed() / newDeltaMovement.m_82553_());
            }
            newDeltaMovement = newDeltaMovement.m_82490_(1.0989010989010988);
            player.m_20256_(newDeltaMovement);
            player.f_19789_ = 0.0f;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UseGliderTrigger.USE_GLIDER.trigger(serverPlayer);
                player.f_19864_ = true;
            } else if (player.m_9236_().m_5776_()) {
                ClientClassLoadingProtection.playSound(player);
            }
            gliderMovementInfo.cause().onHangGliderTick(player);
        }
    }

    public static Optional<GliderMovementInfo> calculateGliderMovementInfo(Player player, boolean displayDisabledMessage) {
        if (!(player.m_20096_() || !(player.m_20184_().m_7098_() < 0.0) || player.m_6144_() || player.m_20069_() || player.m_20159_() || TICKS_FALLING.getOrDefault(player, 0) <= 12)) {
            Optional disabledReason = IntegrationManager.getFirst(integration -> integration.hangGliderDisabledReason(player));
            Optional<GliderMovementInfo> gliderMovementInfo = IntegrationManager.getFirst(integration -> integration.getGliderMovementInfo(player));
            if (displayDisabledMessage && disabledReason.isPresent() && gliderMovementInfo.isPresent()) {
                player.m_5661_((Component)EIOLang.GLIDER_DISABLED.m_6881_().m_7220_((Component)disabledReason.get()), true);
            }
            return gliderMovementInfo;
        }
        return Optional.empty();
    }

    private static class ClientClassLoadingProtection {
        private ClientClassLoadingProtection() {
        }

        private static void playSound(Player player) {
            if (player instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)player;
                if (!ClientClassLoadingProtection.isGliderPlaying()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new WindSoundInstance(localPlayer));
                }
            }
        }

        private static boolean isGliderPlaying() {
            for (SoundInstance soundInstance : Minecraft.m_91087_().m_91106_().f_120349_.f_120227_.get((Object)SoundSource.PLAYERS)) {
                if (!(soundInstance instanceof WindSoundInstance)) continue;
                return true;
            }
            return false;
        }
    }

    private static class WindSoundInstance
    extends AbstractTickableSoundInstance {
        private final LocalPlayer player;
        private int time;

        public WindSoundInstance(LocalPlayer player) {
            super(SoundEvents.f_11886_, SoundSource.PLAYERS, SoundInstance.m_235150_());
            this.player = player;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.1f;
        }

        public void m_7788_() {
            ++this.time;
            if (!this.player.m_213877_() && (this.time <= 20 || PlayerMovementHandler.calculateGliderMovementInfo((Player)this.player, false).isPresent())) {
                this.f_119575_ = this.player.m_20185_();
                this.f_119576_ = this.player.m_20186_();
                this.f_119577_ = this.player.m_20189_();
                float f = (float)this.player.m_20184_().m_82556_();
                this.f_119573_ = (double)f >= 1.0E-7 ? Mth.m_14036_((float)(f / 4.0f), (float)0.0f, (float)1.0f) : 0.0f;
                if (this.time < 20) {
                    this.f_119573_ = 0.0f;
                } else if (this.time < 40) {
                    this.f_119573_ *= (float)(this.time - 20) / 20.0f;
                }
                this.f_119574_ = this.f_119573_ > 0.8f ? 1.0f + (this.f_119573_ - 0.8f) : 1.0f;
            } else {
                this.m_119609_();
            }
        }
    }
}

