/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.handler;

import com.enderio.api.integration.IntegrationManager;
import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.item.darksteel.IDarkSteelItem;
import com.enderio.base.common.travel.TravelSavedData;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class TravelHandler {
    public static final int MIN_TELEPORTATION_DISTANCE_SQUARED = 25;

    public static boolean canTeleport(Player player) {
        return TravelHandler.canItemTeleport(player) || TravelHandler.canBlockTeleport(player);
    }

    public static boolean canItemTeleport(Player player) {
        return TravelHandler.canItemTeleport(player, InteractionHand.MAIN_HAND) || TravelHandler.canItemTeleport(player, InteractionHand.OFF_HAND);
    }

    private static boolean canItemTeleport(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == EIOItems.TRAVEL_STAFF.get()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (item instanceof IDarkSteelItem) {
            IDarkSteelItem iDarkSteelItem = (IDarkSteelItem)item;
        }
        return false;
    }

    public static boolean canBlockTeleport(Player player) {
        return IntegrationManager.anyMatch(integration -> integration.canBlockTeleport(player));
    }

    public static boolean shortTeleport(Level level, Player player) {
        Optional<Vec3> pos = TravelHandler.teleportPosition(level, player);
        if (pos.isPresent()) {
            if (!level.f_46443_) {
                Optional<Vec3> eventPos = TravelHandler.teleportEvent(player, pos.get());
                if (eventPos.isPresent()) {
                    player.m_6021_(eventPos.get().m_7096_(), eventPos.get().m_7098_(), eventPos.get().m_7094_());
                    player.f_19789_ = 0.0f;
                    player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean blockTeleport(Level level, Player player) {
        Optional<ITravelTarget> target = TravelHandler.getAnchorTarget(player);
        if (target.isPresent() && !player.m_9236_().f_46443_) {
            Optional<Double> height = TravelHandler.isTeleportPositionClear((BlockGetter)level, target.get().getPos());
            if (height.isEmpty()) {
                return false;
            }
            BlockPos blockPos = target.get().getPos();
            Vec3 teleportPosition = new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_() + height.get() + 1.0, (double)((float)blockPos.m_123343_() + 0.5f));
            if ((teleportPosition = (Vec3)TravelHandler.teleportEvent(player, teleportPosition).orElse(null)) != null) {
                player.f_19789_ = 0.0f;
                player.m_6021_(teleportPosition.m_7096_(), teleportPosition.m_7098_(), teleportPosition.m_7094_());
                player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public static Optional<Vec3> teleportPosition(Level level, Player player) {
        Vec3 targetVec = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 lookVec = player.m_20154_().m_82541_();
        BlockPos target = null;
        double floorHeight = 0.0;
        for (double i = (double)((Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLINK_RANGE.get()).intValue(); i >= 2.0; i -= 0.5) {
            Vec3 v3d = targetVec.m_82549_(lookVec.m_82490_(i));
            target = new BlockPos((int)Math.round(v3d.f_82479_), (int)Math.round(v3d.f_82480_), (int)Math.round(v3d.f_82481_));
            Optional<Double> ground = TravelHandler.isTeleportPositionClear((BlockGetter)level, target.m_7495_());
            if (ground.isPresent()) {
                floorHeight = ground.get();
                break;
            }
            target = null;
        }
        if (target == null) {
            return Optional.empty();
        }
        return Optional.of(Vec3.m_82539_(target).m_82520_(0.0, floorHeight, 0.0));
    }

    public static Optional<ITravelTarget> getAnchorTarget(Player player) {
        Vec3 positionVec = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        return TravelSavedData.getTravelData(player.m_9236_()).getTravelTargetsInItemRange(player.m_20183_()).filter(target -> target.canTravelTo()).filter(target -> target.getPos().m_203202_(player.m_20185_(), player.m_20186_(), player.m_20189_()) > 25.0).filter(target -> Math.abs(TravelHandler.getAngleRadians(positionVec, target.getPos(), player.m_146908_(), player.m_146909_())) <= Math.toRadians(15.0)).filter(target -> TravelHandler.isTeleportPositionClear((BlockGetter)player.m_9236_(), target.getPos()).isPresent()).min(Comparator.comparingDouble(target -> Math.abs(TravelHandler.getAngleRadians(positionVec, target.getPos(), player.m_146908_(), player.m_146909_()))));
    }

    private static double getAngleRadians(Vec3 positionVec, BlockPos anchor, float yRot, float xRot) {
        Vec3 blockVec = new Vec3((double)anchor.m_123341_() + 0.5 - positionVec.f_82479_, (double)anchor.m_123342_() + 1.0 - positionVec.f_82480_, (double)anchor.m_123343_() + 0.5 - positionVec.f_82481_).m_82541_();
        Vec3 lookVec = Vec3.m_82498_((float)xRot, (float)yRot).m_82541_();
        return Math.acos(lookVec.m_82526_(blockVec));
    }

    private static Optional<Double> isTeleportPositionClear(BlockGetter level, BlockPos target) {
        BlockPos above;
        double height;
        if (level.m_151570_(target)) {
            return Optional.empty();
        }
        if (!level.m_8055_(target.m_6630_(2)).m_60815_() && ((height = level.m_8055_(above = target.m_7494_()).m_60812_(level, above).m_83297_(Direction.Axis.Y)) > 0.2 && !level.m_8055_(target.m_6630_(3)).m_60815_() || height <= 0.2)) {
            if (height == Double.NEGATIVE_INFINITY) {
                height = 0.0;
            }
            return Optional.of(height);
        }
        return Optional.empty();
    }

    private static Optional<Vec3> teleportEvent(Player player, Vec3 target) {
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)player, target.m_7096_(), target.m_7098_(), target.m_7094_());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return Optional.empty();
        }
        return Optional.of(new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ()));
    }
}

