/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capability;

import com.enderio.api.capability.IDarkSteelUpgradable;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.item.darksteel.upgrades.EmpoweredUpgrade;
import java.util.Optional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyDelegator
implements IEnergyStorage {
    private final MultiCapabilityProvider prov;
    private static final EnergyStorage NULL_DELEGATE = new EnergyStorage(0);

    public EnergyDelegator(MultiCapabilityProvider prov) {
        this.prov = prov;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.getDelegate().receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.getDelegate().extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getDelegate().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getDelegate().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getDelegate().canExtract();
    }

    public boolean canReceive() {
        return this.getDelegate().canReceive();
    }

    private IEnergyStorage getDelegate() {
        Optional<EmpoweredUpgrade> energyUp;
        Optional cap = this.prov.getCapability(EIOCapabilities.DARK_STEEL_UPGRADABLE).resolve();
        if (cap.isPresent() && (energyUp = ((IDarkSteelUpgradable)cap.get()).getUpgradeAs("enderio.darksteel.upgrade.empowered", EmpoweredUpgrade.class)).isPresent()) {
            return energyUp.get().getStorage();
        }
        return NULL_DELEGATE;
    }
}

