/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.travel;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.api.travel.TravelEntry;
import com.enderio.api.travel.TravelRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TravelRegistry {
    private static final Map<ResourceLocation, TravelEntry<?>> registry = new HashMap();

    public static <T extends ITravelTarget> void addTravelEntry(ResourceLocation serializationName, Function<CompoundTag, T> constructor, Supplier<Lazy<TravelRenderer<T>>> renderer) {
        registry.put(serializationName, new TravelEntry<T>(serializationName, constructor, renderer));
    }

    public static <T extends ITravelTarget> void addTravelEntry(TravelEntry<?> travelEntry) {
        registry.put(travelEntry.serializationName(), travelEntry);
    }

    public static <T extends ITravelTarget> TravelRenderer<T> getRenderer(T entry) {
        return (TravelRenderer)registry.get(entry.getSerializationName()).renderer().get().get();
    }

    public static Optional<ITravelTarget> deserialize(CompoundTag nbt) {
        return Optional.ofNullable(registry.get(new ResourceLocation(nbt.m_128461_("name")))).map(entry -> (ITravelTarget)entry.constructor().apply(nbt.m_128469_("data")));
    }

    public static boolean isRegistered(ITravelTarget target) {
        return registry.containsKey(target.getSerializationName());
    }

    public static CompoundTag serialize(ITravelTarget travelData) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", travelData.getSerializationName().toString());
        nbt.m_128365_("data", (Tag)travelData.save());
        return nbt;
    }
}

