/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.misc;

import com.enderio.api.misc.ApiLang;
import com.enderio.api.misc.IIcon;
import com.enderio.api.misc.Vector2i;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public enum RedstoneControl implements IIcon
{
    ALWAYS_ACTIVE(bool -> true, ApiLang.REDSTONE_ALWAYS_ACTIVE),
    ACTIVE_WITH_SIGNAL(bool -> bool, ApiLang.REDSTONE_ACTIVE_WITH_SIGNAL),
    ACTIVE_WITHOUT_SIGNAL(bool -> bool == false, ApiLang.REDSTONE_ACTIVE_WITHOUT_SIGNAL),
    NEVER_ACTIVE(bool -> false, ApiLang.REDSTONE_NEVER_ACTIVE);

    private static final ResourceLocation TEXTURE;
    private static final Vector2i SIZE;
    private final UnaryOperator<Boolean> isActive;
    private final Vector2i pos;
    private final Component tooltip;

    private RedstoneControl(UnaryOperator<Boolean> isActive, Component tooltip) {
        this.isActive = isActive;
        this.pos = new Vector2i(12 * this.ordinal(), 0);
        this.tooltip = tooltip;
    }

    public boolean isActive(boolean hasRedstone) {
        return (Boolean)this.isActive.apply(hasRedstone);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    @Override
    public Vector2i getIconSize() {
        return SIZE;
    }

    @Override
    public Vector2i getTexturePosition() {
        return this.pos;
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }

    static {
        TEXTURE = new ResourceLocation("enderio", "textures/gui/icons/redstone_control.png");
        SIZE = new Vector2i(12, 12);
    }
}

