/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.IConduitType;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public interface IExtendedConduitData<T extends IExtendedConduitData<T>>
extends INBTSerializable<CompoundTag> {
    default public void onCreated(IConduitType<?> type, Level level, BlockPos pos, @Nullable Player player) {
    }

    default public void onRemoved(IConduitType<?> type, Level level, BlockPos pos) {
    }

    default public void updateConnection(Set<Direction> connectedSides) {
    }

    default public boolean canConnectTo(T otherData) {
        return true;
    }

    default public void onConnectTo(T otherData) {
    }

    default public boolean syncDataToClient() {
        return false;
    }

    default public CompoundTag serializeRenderNBT() {
        return new CompoundTag();
    }

    default public CompoundTag serializeGuiNBT() {
        return new CompoundTag();
    }

    @UseOnly(value=LogicalSide.CLIENT)
    default public T deepCopy() {
        return (T)this.cast();
    }

    public static Supplier<EmptyExtendedConduitData> dummy() {
        return EmptyExtendedConduitData::new;
    }

    default public <Z extends IExtendedConduitData<Z>> Z cast() {
        return (Z)this;
    }

    default public <Z extends IExtendedConduitData<Z>> Z castTo(Class<Z> clazz) {
        return this.cast();
    }

    public static class EmptyExtendedConduitData
    implements IExtendedConduitData<EmptyExtendedConduitData> {
        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }
}

