/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitTypes;
import com.enderio.api.conduit.IClientConduitData;
import com.enderio.api.conduit.IConduitMenuData;
import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.api.conduit.ticker.IConduitTicker;
import com.enderio.api.misc.RedstoneControl;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public interface IConduitType<T extends IExtendedConduitData<T>> {
    public ResourceLocation getTexture(T var1);

    public ResourceLocation getItemTexture();

    default public Item getConduitItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ConduitTypes.getRegistry().getKey((Object)this));
    }

    default public boolean canBeInSameBlock(IConduitType<?> other) {
        return true;
    }

    default public boolean canBeReplacedBy(IConduitType<?> other) {
        return false;
    }

    public IConduitTicker getTicker();

    @UseOnly(value=LogicalSide.CLIENT)
    public IClientConduitData<T> getClientData();

    public IConduitMenuData getMenuData();

    public T createExtendedConduitData(Level var1, BlockPos var2);

    default public <K> Optional<LazyOptional<K>> proxyCapability(Capability<K> cap, T extendedConduitData, @Nullable Direction direction) {
        return Optional.empty();
    }

    default public ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        return new ConduitConnectionData(false, true, RedstoneControl.NEVER_ACTIVE);
    }

    public record ConduitConnectionData(boolean isInsert, boolean isExtract, RedstoneControl control) {
    }
}

