/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.conduit.IExtendedConduitData;
import com.enderio.api.misc.IIcon;
import com.enderio.api.misc.Vector2i;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public interface IClientConduitData<T extends IExtendedConduitData<T>>
extends IIcon {
    @Override
    default public Vector2i getIconSize() {
        return new Vector2i(24, 24);
    }

    @Override
    default public Vector2i getRenderSize() {
        return new Vector2i(12, 12);
    }

    default public List<AbstractWidget> createWidgets(Screen screen, T extendedConduitData, UpdateExtendedData<T> updateExtendedConduitData, Supplier<Direction> direction, Vector2i widgetsStart) {
        return List.of();
    }

    default public List<BakedQuad> createConnectionQuads(T extendedConduitData, @Nullable Direction facing, Direction connectionDirection, RandomSource rand, @Nullable RenderType type) {
        return List.of();
    }

    default public BakedModel getModel(ResourceLocation model) {
        return Minecraft.m_91087_().m_91304_().getModel(model);
    }

    default public List<ResourceLocation> modelsToLoad() {
        return List.of();
    }

    public static class Simple<T extends IExtendedConduitData<T>>
    implements IClientConduitData<T> {
        private final ResourceLocation textureLocation;
        private final Vector2i texturePosition;

        public Simple(ResourceLocation textureLocation, Vector2i texturePosition) {
            this.textureLocation = textureLocation;
            this.texturePosition = texturePosition;
        }

        @Override
        public ResourceLocation getTextureLocation() {
            return this.textureLocation;
        }

        @Override
        public Vector2i getTexturePosition() {
            return this.texturePosition;
        }

        @Override
        public List<BakedQuad> createConnectionQuads(T extendedConduitData, @Nullable Direction facing, Direction connectionDirection, RandomSource rand, @Nullable RenderType type) {
            return List.of();
        }
    }

    public static interface UpdateExtendedData<T extends IExtendedConduitData<T>> {
        public void update(Function<T, T> var1);
    }
}

